import matplotlib.pyplot as plt
import pandas as pd


label_fontsize = 30  
tick_fontsize = 25  
legend_fontsize = 20  


plt.rcParams['font.family'] = 'Times New Roman'  

file_paths = ['results/SingleRun_FedAvg.csv', 'results/SingleRun_FedProx.csv', 'results/SingleRun_ourmethod.csv', 'results/SingleRun_centralized.csv']
dfs = [pd.read_csv(file_path) for file_path in file_paths]


cases_list = [df['case'].unique() for df in dfs]


labels = ['FedAvg', 'FedProx', 'Our method', 'Centralized Learning']


plt.figure(figsize=(10, 5))
for i, df in enumerate(dfs):

    if df['case'].isnull().all():
        case_data = df.iloc[:80]  
        plt.plot(range(len(case_data)), case_data['lossValue'], label=f'{labels[i]} ')
    else:
        for j, case in enumerate(cases_list[i]):
            case_data = df[df['case'] == case].iloc[:80] 
            plt.plot(range(len(case_data)), case_data['lossValue'], label=f'{labels[i]} - Case {j + 1}')

plt.xlabel('Interation T', fontsize=label_fontsize)  
plt.ylabel('Loss Value', fontsize=label_fontsize)


plt.xticks(fontsize=tick_fontsize)
plt.yticks(fontsize=tick_fontsize)


plt.legend(fontsize=legend_fontsize)


plt.grid(True)


plt.tight_layout()


plt.savefig('loss_plot_rounds_80.png', dpi=300, bbox_inches='tight')
plt.savefig('loss_plot_rounds_80.svg', format='svg', bbox_inches='tight') 
plt.savefig('loss_plot_rounds_80.pdf', format='pdf', bbox_inches='tight')  
plt.show()


plt.figure(figsize=(10, 5))
for i, df in enumerate(dfs):

    if df['case'].isnull().all():
        case_data = df.iloc[:80]  
        plt.plot(range(len(case_data)), case_data['predictionAccuracy'], label=f'{labels[i]} ')
    else:
        for j, case in enumerate(cases_list[i]):
            case_data = df[df['case'] == case].iloc[:80] 
            plt.plot(range(len(case_data)), case_data['predictionAccuracy'], label=f'{labels[i]} - Case {j + 1}')

plt.xlabel('Interation T', fontsize=label_fontsize)  
plt.ylabel('Prediction Accuracy', fontsize=label_fontsize)


plt.xticks(fontsize=tick_fontsize)
plt.yticks(fontsize=tick_fontsize)


plt.legend(fontsize=legend_fontsize)


plt.grid(True)


plt.tight_layout()

plt.savefig('accuracy_plot_rounds_80.png', dpi=300, bbox_inches='tight')
plt.savefig('accuracy_plot_rounds_80.svg', format='svg', bbox_inches='tight')  
plt.savefig('accuracy_plot_rounds_80.pdf', format='pdf', bbox_inches='tight')  
plt.show()
